/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei;

import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.molding.MoldingRecipe;
import slimeknights.tconstruct.plugin.jei.TConstructJEIConstants;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MoldingRecipeCategory
implements IRecipeCategory<MoldingRecipe> {
    private static final class_2960 BACKGROUND_LOC = TConstruct.getResource("textures/gui/jei/casting.png");
    private static final class_2561 TITLE = TConstruct.makeTranslation("jei", "molding.title");
    private static final class_2561 TOOLTIP_PATTERN_CONSUMED = class_2561.method_43471((String)TConstruct.makeTranslationKey("jei", "molding.pattern_consumed"));
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable table;
    private final IDrawable basin;
    private final IDrawable downArrow;
    private final IDrawable upArrow;

    public MoldingRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(BACKGROUND_LOC, 0, 55, 70, 57);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)TinkerSmeltery.blankSandCast.get()));
        this.table = helper.createDrawable(BACKGROUND_LOC, 117, 0, 16, 16);
        this.basin = helper.createDrawable(BACKGROUND_LOC, 117, 16, 16, 16);
        this.downArrow = helper.createDrawable(BACKGROUND_LOC, 70, 55, 6, 6);
        this.upArrow = helper.createDrawable(BACKGROUND_LOC, 76, 55, 6, 6);
    }

    public RecipeType<MoldingRecipe> getRecipeType() {
        return TConstructJEIConstants.MOLDING;
    }

    public class_2561 getTitle() {
        return TITLE;
    }

    public void draw(MoldingRecipe recipe, IRecipeSlotsView slots, class_332 graphics, double mouseX, double mouseY) {
        IDrawable block = recipe.method_17716() == TinkerRecipeTypes.MOLDING_BASIN.get() ? this.basin : this.table;
        block.draw(graphics, 3, 40);
        if (!recipe.getPattern().method_8103()) {
            block.draw(graphics, 51, 40);
            this.downArrow.draw(graphics, 8, 17);
        } else {
            this.upArrow.draw(graphics, 8, 17);
        }
    }

    public List<class_2561> getTooltipStrings(MoldingRecipe recipe, IRecipeSlotsView slots, double mouseX, double mouseY) {
        if (recipe.isPatternConsumed() && !recipe.getPattern().method_8103() && GuiUtil.isHovered((int)mouseX, (int)mouseY, 50, 7, 18, 18)) {
            return Collections.singletonList(TOOLTIP_PATTERN_CONSUMED);
        }
        return Collections.emptyList();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MoldingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 3, 24).addIngredients(recipe.getMaterial());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 51, 24).addItemStack(recipe.method_8110(class_310.method_1551().field_1687.method_30349()));
        class_1856 pattern = recipe.getPattern();
        if (!pattern.method_8103()) {
            IRecipeSlotBuilder inputSlot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 3, 1).addIngredients(pattern);
            if (!recipe.isPatternConsumed()) {
                IRecipeSlotBuilder preservedSlot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 51, 8).addIngredients(pattern);
                builder.createFocusLink(new IIngredientAcceptor[]{inputSlot, preservedSlot});
            }
        }
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }
}

